/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.core.init.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.LivingEntityLoadAdditionalEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntitiesTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FireTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FreezingTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.UndergroundTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.temperature.AbstractTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.CarriedItemTemperature;
import com.momosoftworks.coldsweat.config.type.InsulatingMount;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class EntityTempManager {
    public static final Temperature.Trait[] VALID_TEMPERATURE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForTemperature).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_MODIFIER_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForModifiers).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_ATTRIBUTE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForAttributes).toArray(Temperature.Trait[]::new);
    public static final Set<EntityType<? extends LivingEntity>> TEMPERATURE_ENABLED_ENTITIES = new HashSet<EntityType>(List.of(EntityType.f_20532_));
    public static final Map<Entity, LazyOptional<ITemperatureCap>> SERVER_CAP_CACHE = new HashMap<Entity, LazyOptional<ITemperatureCap>>();
    public static final Map<Entity, LazyOptional<ITemperatureCap>> CLIENT_CAP_CACHE = new HashMap<Entity, LazyOptional<ITemperatureCap>>();

    public static LazyOptional<ITemperatureCap> getTemperatureCap(Entity entity) {
        Map<Entity, LazyOptional<ITemperatureCap>> cache = entity.f_19853_.f_46443_ ? CLIENT_CAP_CACHE : SERVER_CAP_CACHE;
        return cache.computeIfAbsent(entity, e -> {
            LazyOptional cap = e.getCapability(ModCapabilities.ENTITY_TEMPERATURE);
            if (cache == SERVER_CAP_CACHE) {
                cap.addListener(opt -> SERVER_CAP_CACHE.remove(e));
            }
            return cap;
        });
    }

    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        LivingEntity entity;
        Object object = event.getObject();
        if (object instanceof LivingEntity && TEMPERATURE_ENABLED_ENTITIES.contains((entity = (LivingEntity)object).m_6095_())) {
            final AbstractTempCap tempCap = entity instanceof Player ? new PlayerTempCap() : new EntityTempCap();
            final LazyOptional capOptional = LazyOptional.of(() -> tempCap);
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                    if (cap == ModCapabilities.ENTITY_TEMPERATURE) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return tempCap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    tempCap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "temperature"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void initModifiersOnEntity(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.f_19853_.m_5776_() && EntityTempManager.isTemperatureEnabled(living.m_6095_())) {
                EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                    for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                        GatherDefaultTempModifiersEvent gatherEvent = new GatherDefaultTempModifiersEvent(living, trait);
                        MinecraftForge.EVENT_BUS.post((Event)gatherEvent);
                        cap.getModifiers(trait).clear();
                        cap.getModifiers(trait).addAll(gatherEvent.getModifiers());
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void fixOldAttributeData(LivingEntityLoadAdditionalEvent event) {
        if (EntityTempManager.isTemperatureEnabled(event.getEntity().m_6095_()) && event.getNBT().m_128437_("Attributes", 10).stream().anyMatch(attribute -> ((CompoundTag)attribute).m_128461_("Name").equals("cold_sweat:world_temperature_offset"))) {
            TaskScheduler.scheduleServer(() -> {
                for (Temperature.Trait attributeType : VALID_ATTRIBUTE_TRAITS) {
                    CSMath.doIfNotNull(EntityTempManager.getAttribute(attributeType, event.getEntity()), attribute -> {
                        attribute.m_22132_();
                        attribute.m_22100_(attribute.m_22099_().m_22082_());
                    });
                }
            }, 1);
        }
    }

    @SubscribeEvent
    public static void tickTemperature(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!TEMPERATURE_ENABLED_ENTITIES.contains(entity.m_6095_())) {
            return;
        }
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            if (!entity.f_19853_.f_46443_) {
                cap.tick(entity);
            } else {
                cap.tickDummy(entity);
            }
            for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                cap.getModifiers(trait).removeIf(modifier -> {
                    int expireTime = modifier.getExpireTime();
                    return modifier.setTicksExisted(modifier.getTicksExisted() + 1) > expireTime && expireTime != -1;
                });
            }
            if (entity instanceof Player && entity.f_19797_ % 60 == 0) {
                Temperature.updateModifiers(entity, cap);
            }
        });
    }

    @SubscribeEvent
    public static void tickInventoryTempItems(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.f_19797_ % 10 != 0 || !EntityTempManager.isTemperatureEnabled(event.getEntity().m_6095_())) {
            return;
        }
        Map effectsPerTrait = Arrays.stream(VALID_MODIFIER_TRAITS).collect(() -> new EnumMap(Temperature.Trait.class), (map, type) -> map.put(type, 0.0), EnumMap::putAll);
        FastMap effectsPerCarriedTemp = new FastMap();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)item).forEach(carried -> EntityTempManager.checkAndAddCarriedTemp(entity, stack, null, slot, carried, effectsPerCarriedTemp));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (Slot slot : player.f_36095_.f_38839_) {
                ItemStack stack = slot.m_7993_();
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)item).forEach(carried -> EntityTempManager.checkAndAddCarriedTemp(entity, stack, slot.f_40219_, null, carried, effectsPerCarriedTemp));
            }
        }
        for (Map.Entry entry : effectsPerCarriedTemp.entrySet()) {
            Temperature.Trait trait2 = ((CarriedItemTemperature)entry.getKey()).trait();
            double temp2 = (Double)entry.getValue();
            effectsPerTrait.put(trait2, (Double)effectsPerTrait.get((Object)trait2) + temp2);
        }
        effectsPerTrait.forEach((trait, temp) -> {
            Optional<InventoryItemsTempModifier> modifier = Temperature.getModifier(entity, trait, InventoryItemsTempModifier.class);
            if (modifier.isEmpty()) {
                Temperature.addModifier(entity, new InventoryItemsTempModifier((double)temp), trait, Placement.Duplicates.BY_CLASS);
            } else {
                modifier.get().getNBT().m_128347_("Effect", temp.doubleValue());
            }
        });
    }

    private static void checkAndAddCarriedTemp(LivingEntity entity, ItemStack stack, Integer slot, EquipmentSlot equipmentSlot, CarriedItemTemperature carried, Map<CarriedItemTemperature, Double> effectsPerCarriedTemp) {
        if (carried.testEntity(entity) && carried.testSlot(stack, slot, equipmentSlot)) {
            double temp = carried.temperature() * (double)stack.m_41613_();
            double currentEffect = effectsPerCarriedTemp.getOrDefault(carried, 0.0);
            double newEffect = Math.min(carried.maxEffect(), Math.abs(currentEffect + temp)) * (double)CSMath.sign(currentEffect + temp);
            effectsPerCarriedTemp.put(carried, newEffect);
        }
    }

    @SubscribeEvent
    public static void clearClientCapCache(TickEvent.ClientTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END && ClientOnlyHelper.getClientLevel() != null && ClientOnlyHelper.getClientLevel().m_46467_() % 5L == 0L) {
            CLIENT_CAP_CACHE.clear();
        }
    }

    @SubscribeEvent
    public static void carryOverPersistentAttributes(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (!newPlayer.f_19853_.f_46443_) {
            oldPlayer.reviveCaps();
            ((Collection)EntityTempManager.getTemperatureCap((Entity)oldPlayer).map(ITemperatureCap::getPersistentAttributes).orElse(new HashSet())).forEach(attr -> newPlayer.m_21051_(attr).m_22100_(oldPlayer.m_21051_(attr).m_22115_()));
            oldPlayer.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void handlePlayerReset(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        SERVER_CAP_CACHE.remove(oldPlayer);
        CLIENT_CAP_CACHE.remove(oldPlayer);
        EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> {
            if (!event.isWasDeath()) {
                oldPlayer.reviveCaps();
                EntityTempManager.getTemperatureCap((Entity)oldPlayer).ifPresent(cap::copy);
                oldPlayer.invalidateCaps();
            }
            if (!newPlayer.f_19853_.f_46443_) {
                Temperature.updateTemperature((LivingEntity)newPlayer, cap, true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void defineDefaultModifiers(GatherDefaultTempModifiersEvent event) {
        if (event.getEntity() instanceof Player) {
            if (event.getTrait() == Temperature.Trait.WORLD) {
                event.addModifier(new BiomeTempModifier(25).tickRate(10), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
                event.addModifier(new UndergroundTempModifier().tickRate(10), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
                event.addModifier(new BlockTempModifier().tickRate(4), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
                event.addModifier(new EntitiesTempModifier().tickRate(10), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
                event.addModifierById(new ResourceLocation("sereneseasons:season"), mod -> mod.tickRate(60), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier));
                event.addModifierById(new ResourceLocation("weather2:storm"), mod -> mod.tickRate(60), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier));
                event.addModifierById(new ResourceLocation("valkyrienskies:ship_blocks"), mod -> mod.tickRate(10), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BlockTempModifier));
            }
            if (event.getTrait().isForModifiers()) {
                event.addModifier(new InventoryItemsTempModifier(), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            }
        } else if (event.getTrait() == Temperature.Trait.WORLD && TEMPERATURE_ENABLED_ENTITIES.contains(event.getEntity().m_6095_())) {
            event.addModifier(new BiomeTempModifier(16).tickRate(40), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
            event.addModifier(new UndergroundTempModifier(16).tickRate(40), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
            event.addModifier(new BlockTempModifier(4).tickRate(20), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifier(new EntitiesTempModifier().tickRate(10), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            if (CompatManager.isSereneSeasonsLoaded()) {
                TempModifierRegistry.getValue(new ResourceLocation("sereneseasons:season")).ifPresent(mod -> event.addModifier(mod.tickRate(60), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier)));
            }
            if (CompatManager.isWeather2Loaded()) {
                TempModifierRegistry.getValue(new ResourceLocation("weather2:storm")).ifPresent(mod -> event.addModifier(mod.tickRate(60), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier)));
            }
        }
    }

    @SubscribeEvent
    public static void addSewingIngredientListener(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            final Player player = (Player)entity;
            player.f_36096_.m_38893_(new ContainerListener(){

                public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
                    Slot slot = menu.m_38853_(slotIndex);
                    if (!(slot instanceof ResultSlot) && slot.f_40218_ == player.m_150109_() && ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.m_41720_())) {
                        player.m_7902_(new ResourceLocation[]{new ResourceLocation("cold_sweat", "sewing_table")});
                    }
                }

                public void m_142153_(AbstractContainerMenu menu, int slot, int value) {
                }
            });
        }
    }

    @SubscribeEvent
    public static void cancelImmuneModifiers(TempModifierEvent.Calculate.Pre event) {
        TempModifier modifier = event.getModifier();
        LivingEntity entity = event.getEntity();
        ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
        if (ConfigSettings.DISABLED_MODIFIERS.get().contains(modifierKey)) {
            if (modifier instanceof BiomeTempModifier) {
                event.setFunction(temp -> temp + (Temperature.get(entity, Temperature.Trait.FREEZING_POINT) + Temperature.get(entity, Temperature.Trait.BURNING_POINT)) / 2.0);
            } else {
                event.setFunction(temp -> temp);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void checkModifierImmunity(TempModifierEvent.Calculate.Post event) {
        if (event.getEntity() instanceof DummyPlayer) {
            return;
        }
        if (!event.getTrait().isForAttributes()) {
            return;
        }
        TempModifier modifier = event.getModifier();
        ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
        LivingEntity entity = event.getEntity();
        double lastInput = modifier instanceof BiomeTempModifier ? (Temperature.get(entity, Temperature.Trait.FREEZING_POINT) + Temperature.get(entity, Temperature.Trait.BURNING_POINT)) / 2.0 : modifier.getLastInput();
        for (Map.Entry<ItemStack, Insulator> entry : EntityTempManager.getInsulatorsOnEntity(entity).entrySet()) {
            Insulator insulator = entry.getValue();
            ItemStack stack = entry.getKey();
            Double immunity = insulator.immuneTempModifiers().get(modifierKey);
            if (immunity == null || !insulator.test((Entity)entity, stack)) continue;
            Function<Double, Double> func = event.getFunction();
            event.setFunction(temp -> CSMath.blend((Double)func.apply((Double)temp), lastInput, immunity, 0.0, 1.0));
        }
    }

    @SubscribeEvent
    public static void handleWaterAndFreezing(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.START) {
            if (player.f_19797_ % 5 == 0) {
                if (!player.m_5833_() && (WorldHelper.isInWater((Entity)player) || player.f_19797_ % 40 == 0 && WorldHelper.isRainingAt(player.f_19853_, player.m_20183_()))) {
                    Temperature.addModifier((LivingEntity)player, new WaterTempModifier(0.01f).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                }
                if (player.m_203117_()) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, new FreezingTempModifier((float)player.m_146888_() / 13.5f).expires(5), Temperature.Trait.BASE, Placement.Duplicates.BY_CLASS);
                }
                if (player.m_6060_()) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, new FireTempModifier().expires(5), Temperature.Trait.BASE, Placement.Duplicates.BY_CLASS);
                }
            }
            if (player.m_203117_() && player.m_146888_() > 0) {
                boolean hasIcePotion;
                AtomicReference<Double> insulation = new AtomicReference<Double>(0.0);
                boolean bl = hasIcePotion = player.m_21023_(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false;
                if (!hasIcePotion) {
                    Temperature.getModifier((LivingEntity)player, Temperature.Trait.RATE, ArmorInsulationTempModifier.class).ifPresent(insulModifier -> insulation.updateAndGet(v -> v + insulModifier.getNBT().m_128459_("Hot") + insulModifier.getNBT().m_128459_("Cold")));
                }
                if (!hasIcePotion && !(insulation.get() > 0.0) && (double)player.f_19797_ % Math.max(1.0, 37.0 - insulation.get()) == 0.0) {
                    player.m_146917_(player.m_146888_() - 1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void updateAttributeModifiersOnSlotChange(LivingEquipmentChangeEvent event) {
        EntityTempManager.updateInsulationAttributeModifiers(event.getEntity());
    }

    public static void updateInsulationAttributeModifiers(LivingEntity entity) {
        Stream.of(ConfigSettings.INSULATION_ITEMS.get().values(), ConfigSettings.INSULATING_ARMORS.get().values(), ConfigSettings.INSULATING_CURIOS.get().values()).flatMap(Collection::stream).forEach(insulator -> {
            for (Map.Entry entry : insulator.attributes().getMap().entries()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                AttributeInstance instance = entity.m_21051_(attribute);
                if (instance == null) continue;
                instance.m_22130_(modifier);
            }
        });
        for (Map.Entry<ItemStack, Insulator> insulationItem : EntityTempManager.getInsulatorsOnEntity(entity).entrySet()) {
            ItemStack stack;
            Insulator insulator2 = insulationItem.getValue();
            if (!insulator2.test((Entity)entity, stack = insulationItem.getKey())) continue;
            for (Map.Entry entry : insulator2.attributes().getMap().entries()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                AttributeInstance instance = entity.m_21051_(attribute);
                if (instance == null) continue;
                instance.m_22118_(modifier);
            }
        }
    }

    @SubscribeEvent
    public static void cancelFreezingDamage(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.f_146701_ && event.getEntity().m_21023_(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInsulationAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (!entity.f_19853_.f_46443_ && EntityTempManager.isTemperatureEnabled(entity.m_6095_()) && (effect.m_19544_() == ModEffects.CHILL || effect.m_19544_() == ModEffects.WARMTH)) {
            boolean isWarmth = effect.m_19544_() == ModEffects.WARMTH;
            int warming = isWarmth ? effect.m_19564_() + 1 : 0;
            int cooling = !isWarmth ? effect.m_19564_() + 1 : 0;
            Optional<BlockInsulationTempModifier> oldMod = Temperature.getModifier(entity, Temperature.Trait.WORLD, BlockInsulationTempModifier.class);
            if (oldMod.isPresent()) {
                CompoundTag nbt = oldMod.get().getNBT();
                nbt.m_128405_("Warming", Math.max(nbt.m_128451_("Warming"), warming));
                nbt.m_128405_("Cooling", Math.max(nbt.m_128451_("Cooling"), cooling));
                oldMod.get().setTicksExisted(0);
                oldMod.get().expires(effect.m_19557_());
            } else {
                TempModifier newMod = new BlockInsulationTempModifier(cooling, warming).expires(effect.m_19557_());
                Temperature.addOrReplaceModifier(entity, newMod, Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
            }
        }
    }

    @SubscribeEvent
    public static void onInsulationRemoved(MobEffectEvent.Remove event) {
        Optional<BlockInsulationTempModifier> modifier;
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (effect != null && !entity.f_19853_.f_46443_ && EntityTempManager.isTemperatureEnabled(entity.m_6095_()) && (effect.m_19544_() == ModEffects.CHILL || effect.m_19544_() == ModEffects.WARMTH) && (modifier = Temperature.getModifier(entity, Temperature.Trait.WORLD, BlockInsulationTempModifier.class)).isPresent()) {
            boolean isWarmth = effect.m_19544_() == ModEffects.WARMTH;
            CompoundTag nbt = modifier.get().getNBT();
            if (isWarmth) {
                nbt.m_128405_("Warming", 0);
            } else {
                nbt.m_128405_("Cooling", 0);
            }
            if (isWarmth ? !entity.m_21023_(ModEffects.CHILL) : !entity.m_21023_(ModEffects.WARMTH)) {
                Temperature.removeModifiers(entity, Temperature.Trait.WORLD, mod -> mod instanceof BlockInsulationTempModifier);
            }
        }
    }

    @SubscribeEvent
    public static void onSleep(SleepFinishedTimeEvent event) {
        if (!event.getLevel().m_5776_()) {
            event.getLevel().m_6907_().forEach(player -> {
                if (player.m_5803_()) {
                    EntityTempManager.getTemperatureCap((Entity)player).ifPresent(cap -> {
                        double temp = cap.getTrait(Temperature.Trait.CORE);
                        cap.setTrait(Temperature.Trait.CORE, temp / 4.0);
                        Temperature.updateTemperature((LivingEntity)player, cap, true);
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerRiding(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && !event.player.f_19853_.m_5776_() && event.player.f_19797_ % 5 == 0 && (player = event.player).m_20202_() != null) {
            Minecart minecart;
            Entity mount = player.m_20202_();
            if (mount instanceof Minecart && (minecart = (Minecart)mount).m_38178_().m_60734_() == ModBlocks.MINECART_INSULATION) {
                Temperature.addOrReplaceModifier((LivingEntity)player, new MountTempModifier(1.0, 1.0).tickRate(5).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
            } else {
                InsulatingMount entityInsul = ConfigSettings.INSULATED_ENTITIES.get().get((Object)mount.m_6095_()).stream().filter(mnt -> mnt.test(mount)).findFirst().orElse(null);
                if (entityInsul != null && entityInsul.test(mount)) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, new MountTempModifier(entityInsul.coldInsulation(), entityInsul.heatInsulation()).tickRate(5).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEatFood(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!(event.getItem().m_41780_() != UseAnim.DRINK && event.getItem().m_41780_() != UseAnim.EAT || event.getEntity().f_19853_.f_46443_)) {
                for (PredicateItem foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)event.getItem().m_41720_())) {
                    if (foodData == null || !foodData.test(event.getItem())) continue;
                    double effect = foodData.value();
                    if (foodData.extraData().m_128425_("duration", 3)) {
                        int duration = foodData.extraData().m_128451_("duration");
                        FoodTempModifier foodModifier = event.getItem().m_41720_() == ModItems.SOUL_SPROUT ? new SoulSproutTempModifier(effect) : new FoodTempModifier(effect);
                        foodModifier.getNBT().m_128365_("extraData", (Tag)foodData.extraData());
                        Temperature.addModifier((LivingEntity)player, foodModifier.expires(duration), Temperature.Trait.BASE, Placement.Duplicates.BY_CLASS);
                        continue;
                    }
                    Temperature.addModifier((LivingEntity)player, new FoodTempModifier(effect).expires(0), Temperature.Trait.CORE, Placement.Duplicates.EXACT);
                }
            }
        }
    }

    public static Set<EntityType<? extends LivingEntity>> getEntitiesWithTemperature() {
        return ImmutableSet.copyOf(TEMPERATURE_ENABLED_ENTITIES);
    }

    public static boolean isTemperatureEnabled(EntityType<?> type) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(type);
    }

    public static boolean immuneToTempEffects(LivingEntity entity) {
        return entity.f_19853_.m_46791_() == Difficulty.PEACEFUL && ConfigSettings.USE_PEACEFUL_MODE.get() != false;
    }

    public static Map<ItemStack, Insulator> getInsulatorsOnEntity(LivingEntity entity) {
        HashMap<ItemStack, Insulator> insulators = new HashMap<ItemStack, Insulator>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = entity.m_6844_(slot)).m_41619_()) continue;
            ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.m_41720_()).forEach(insul -> insulators.put(stack, (Insulator)insul));
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> ConfigSettings.INSULATION_ITEMS.get().get((Object)item.m_41720_()).forEach(insul -> insulators.put((ItemStack)item, (Insulator)insul))));
        }
        for (ItemStack curio : CompatManager.getCurios(entity)) {
            ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.m_41720_()).forEach(insul -> insulators.put(curio, (Insulator)insul));
        }
        return insulators;
    }

    public static void setAttribute(Temperature.Trait trait, LivingEntity entity, double value) {
        switch (trait) {
            case WORLD: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.WORLD_TEMPERATURE), att -> att.m_22100_(value));
                break;
            }
            case BASE: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.BASE_BODY_TEMPERATURE), att -> att.m_22100_(value));
                break;
            }
            case HEAT_RESISTANCE: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.HEAT_RESISTANCE), att -> att.m_22100_(value));
                break;
            }
            case COLD_RESISTANCE: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.COLD_RESISTANCE), att -> att.m_22100_(value));
                break;
            }
            case HEAT_DAMPENING: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.HEAT_DAMPENING), att -> att.m_22100_(value));
                break;
            }
            case COLD_DAMPENING: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.COLD_DAMPENING), att -> att.m_22100_(value));
                break;
            }
            case FREEZING_POINT: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.FREEZING_POINT), att -> att.m_22100_(value));
                break;
            }
            case BURNING_POINT: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.BURNING_POINT), att -> att.m_22100_(value));
            }
        }
    }

    @Nullable
    public static AttributeInstance getAttribute(Temperature.Trait trait, LivingEntity entity) {
        return switch (trait) {
            case Temperature.Trait.WORLD -> entity.m_21051_(ModAttributes.WORLD_TEMPERATURE);
            case Temperature.Trait.BASE -> entity.m_21051_(ModAttributes.BASE_BODY_TEMPERATURE);
            case Temperature.Trait.FREEZING_POINT -> entity.m_21051_(ModAttributes.FREEZING_POINT);
            case Temperature.Trait.BURNING_POINT -> entity.m_21051_(ModAttributes.BURNING_POINT);
            case Temperature.Trait.HEAT_RESISTANCE -> entity.m_21051_(ModAttributes.HEAT_RESISTANCE);
            case Temperature.Trait.COLD_RESISTANCE -> entity.m_21051_(ModAttributes.COLD_RESISTANCE);
            case Temperature.Trait.HEAT_DAMPENING -> entity.m_21051_(ModAttributes.HEAT_DAMPENING);
            case Temperature.Trait.COLD_DAMPENING -> entity.m_21051_(ModAttributes.COLD_DAMPENING);
            default -> throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
        };
    }

    public static Collection<AttributeModifier> getAllAttributeModifiers(LivingEntity entity, AttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation == null ? attribute.m_22122_() : attribute.m_22104_(operation));
        modifiers.addAll(EntityTempManager.getAllEquipmentAttributeModifiers(entity, attribute, operation));
        return modifiers;
    }

    public static Collection<AttributeModifier> getAllEquipmentAttributeModifiers(LivingEntity entity, AttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = entity.m_6844_(slot)).m_41619_()) continue;
            modifiers.addAll(ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute.m_22099_(), slot, operation, (Entity)entity));
        }
        return modifiers;
    }

    public static AttributeModifier makeAttributeModifier(Temperature.Trait trait, double value, AttributeModifier.Operation operation) {
        return switch (trait) {
            case Temperature.Trait.WORLD -> new AttributeModifier("World Temperature Modifier", value, operation);
            case Temperature.Trait.BASE -> new AttributeModifier("Base Body Temperature Modifier", value, operation);
            case Temperature.Trait.FREEZING_POINT -> new AttributeModifier("Freezing Point Modifier", value, operation);
            case Temperature.Trait.BURNING_POINT -> new AttributeModifier("Burning Point Modifier", value, operation);
            case Temperature.Trait.HEAT_RESISTANCE -> new AttributeModifier("Heat Resistance Modifier", value, operation);
            case Temperature.Trait.COLD_RESISTANCE -> new AttributeModifier("Cold Resistance Modifier", value, operation);
            case Temperature.Trait.HEAT_DAMPENING -> new AttributeModifier("Heat Dampening Modifier", value, operation);
            case Temperature.Trait.COLD_DAMPENING -> new AttributeModifier("Cold Dampening Modifier", value, operation);
            default -> throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
        };
    }

    public static boolean isTemperatureAttribute(Attribute attribute) {
        return CSMath.containsAny(ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString(), (String[])Arrays.stream(VALID_ATTRIBUTE_TRAITS).map(Temperature.Trait::m_7912_).toArray(String[]::new));
    }

    public static List<TempModifier> getAllModifiers(LivingEntity entity) {
        ArrayList<TempModifier> allModifiers = new ArrayList<TempModifier>();
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                allModifiers.addAll(cap.getModifiers(trait));
            }
        });
        return allModifiers;
    }
}

